/********************************************************************************/
/*Ce logiciel permet de :														*/
/*  	# piloter Robotino ;													*/
/*		# obtenir l'information associe aux diffrents capteurs ;				*/
/*		# lancer diffrents algorithmes de dtection d'obstacle 				*/
/* 			ou de suivi de trajectoire ;										*/
/* 		# traiter la vido du Robotino (cartomtre + filtres de dtection		*/
/*			de contour).														*/
/* 																				*/
/* Copyright (C) <2012>  <Franck RIVIER>										*/	
/*																				*/
/*This file is part of RobotinoSti2d.                                           */
/*                                                                              */
/*RobotinoSti2d is free software: you can redistribute it and/or modify			*/
/*it under the terms of the GNU General Public License as published by			*/
/*the Free Software Foundation, either version 3 of the License, or		 		*/
/*(at your option) any later version.											*/
/*																				*/
/*RobotinoSti2d is distributed in the hope that it will be useful,				*/
/*but WITHOUT ANY WARRANTY; without even the implied warranty of				*/
/*MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the					*/
/*GNU General Public License for more details.									*/
/*																				*/
/*You should have received a copy of the GNU General Public License				*/
/*along with RobotinoSti2d.  If not, see <http://www.gnu.org/licenses/>.		*/
/* 																				*/
/*********************************************************************************/
package robotino;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
//import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;

/**
 * Composant graphique qui permet de piloter les moteurs du Robotino.
 * 
 * @author Franck RIVIER
 * 
 */
public class DriveWidget extends JComponent {

	protected final Robot robot;
	// protected static final float speed = 50.0f;
	// protected static final float rotSpeed = 20.0f;
	protected final JButton buttonUp;
	protected final JButton buttonDown;
	protected final JButton buttonRight;
	protected final JButton buttonLeft;
	protected final JButton buttonCL;
	protected final JButton buttonCCL;
	protected final JButton buttonStop;
	// protected ButtonListener buttonListener;
	protected ButtonUpListener buttonUpListener;
	protected ButtonDownListener buttonDownListener;
	protected ButtonStopListener buttonStopListener;
	protected ButtonRightListener buttonRightListener;
	protected ButtonLeftListener buttonLeftListener;
	protected ButtonClockWiseListener buttonClockWiseListener;
	protected ButtonCounterClockWiseListener buttonCounterClockWiseListener;
	protected float speed;

	public DriveWidget(Robot robot) {

		this.robot = robot;
		setLayout(new GridLayout(3, 5));

		buttonUp = new JButton(new ImageIcon(
				DriveWidget.class.getResource("/robotino/icons/n.png")));
		buttonDown = new JButton(new ImageIcon(
				DriveWidget.class.getResource("/robotino/icons/s.png")));
		buttonRight = new JButton(new ImageIcon(
				DriveWidget.class.getResource("/robotino/icons/o.png")));
		buttonLeft = new JButton(new ImageIcon(
				DriveWidget.class.getResource("/robotino/icons/w.png")));
		buttonLeft.setSelectedIcon(null);
		buttonCL = new JButton(new ImageIcon(
				DriveWidget.class.getResource("/robotino/icons/cl.png")));
		buttonCCL = new JButton(new ImageIcon(
				DriveWidget.class.getResource("/robotino/icons/ccl.png")));
		buttonStop = new JButton(new ImageIcon(
				DriveWidget.class.getResource("/robotino/icons/stop.png")));

		add(new JLabel());
		add(new JLabel());
		add(buttonUp);
		add(new JLabel());
		add(new JLabel());
		add(buttonCCL);
		add(buttonLeft);
		add(buttonStop);
		add(buttonRight);
		add(buttonCL);
		add(new JLabel());
		add(new JLabel());
		add(buttonDown);

		/*
		 * buttonListener = new ButtonListener();
		 * buttonDown.addActionListener(buttonListener);
		 * buttonRight.addActionListener(buttonListener);
		 * buttonLeft.addActionListener(buttonListener);
		 * buttonCL.addActionListener(buttonListener);
		 * buttonCCL.addActionListener(buttonListener);
		 * buttonStop.addActionListener(buttonListener);
		 */

		buttonUpListener = new ButtonUpListener();
		buttonUp.addActionListener(buttonUpListener);
		buttonDownListener = new ButtonDownListener();
		buttonDown.addActionListener(buttonDownListener);
		buttonStopListener = new ButtonStopListener();
		buttonStop.addActionListener(buttonStopListener);
		buttonRightListener = new ButtonRightListener();
		buttonRight.addActionListener(buttonRightListener);
		buttonLeftListener = new ButtonLeftListener();
		buttonLeft.addActionListener(buttonLeftListener);
		buttonClockWiseListener = new ButtonClockWiseListener();
		buttonCL.addActionListener(buttonClockWiseListener);
		buttonCounterClockWiseListener = new ButtonCounterClockWiseListener();
		buttonCCL.addActionListener(buttonCounterClockWiseListener);

		setPreferredSize(new Dimension(200, 120));
	}

	/*
	 * Pour des raisons pdagogiques (appel de setVelocity() plutt que
	 * robot.setVelocity()
	 */
	public void setVelocity(float vx, float vy, float omega) {
		robot.setVelocity(vx, vy, omega);
	}

	public void enableWidget(boolean enable) {

		if (enable == true) {
			buttonUp.setEnabled(true);
			buttonDown.setEnabled(true);
			buttonRight.setEnabled(true);
			buttonLeft.setEnabled(true);
			buttonCL.setEnabled(true);
			buttonCCL.setEnabled(true);
			buttonStop.setEnabled(true);

		} else {
			buttonUp.setEnabled(false);
			buttonDown.setEnabled(false);
			buttonRight.setEnabled(false);
			buttonLeft.setEnabled(false);
			buttonCL.setEnabled(false);
			buttonCCL.setEnabled(false);
			buttonStop.setEnabled(false);
		}
	}

	public class ButtonClockWiseListener implements ActionListener {

		public void actionPerformed(ActionEvent arg0) {

			// Entrez sur la ligne suivante votre code

		}

	}

	public class ButtonCounterClockWiseListener implements ActionListener {

		public void actionPerformed(ActionEvent arg0) {

			// Entrez sur la ligne suivante votre code

		}

	}

	public class ButtonDownListener implements ActionListener {

		public void actionPerformed(ActionEvent arg0) {

			// Entrez sur la ligne suivante votre code

		}

	}

	public class ButtonLeftListener implements ActionListener {

		public void actionPerformed(ActionEvent arg0) {

			// Entrez sur la ligne suivante votre code

		}

	}

	public class ButtonRightListener implements ActionListener {

		public void actionPerformed(ActionEvent arg0) {

			// Entrez sur la ligne suivante votre code
		}

	}

	public class ButtonStopListener implements ActionListener {
		// Fonction appele lors de l'appui sur le bouton arrt
		public void actionPerformed(ActionEvent arg0) {

			setVelocity(0, 0, 0);
		}

	}

	public class ButtonUpListener implements ActionListener {
		// Fonction appele lors de l'appui sur le bouton marche avant
		public void actionPerformed(ActionEvent arg0) {

			setVelocity(50, 0, 0);
		}

	}

}
